package model;

import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;

class SimpleMachine extends Machine {
    final static int WATER_MAX = Integer.MAX_VALUE;
    final static int COFFEE_MAX = 10;
    
    private Ingredient hotwater, coffee;
    private BasicDisplay display;

    SimpleMachine() {
        super("Dave's Less Famous Coffee Machine");

    }

    void initialiseIngredients() {
        hotwater  = new Ingredient("Water", WATER_MAX, dispenser);
        coffee    = new Ingredient("Coffee", COFFEE_MAX, dispenser);
        display   = new BasicDisplay();

        coffee.onEmpty( s -> { display.setRed(); } );
    }

    void populateMenu() {
        menu.add(new Button(1, "Tea", b -> this.tea()));
        menu.add(new Button(2, "Coffee", b -> this.coffee()));
        menu.add(new TextItem(""));
        menu.add(new Button(100, "Dispense", b -> this.dispense()));
    }
    
    void tea() {
        display.setGreen();
        hotwater.use();
    }
    
    void coffee() {
        display.setYellow();
        coffee.use();
    }

    
    void dispense() {
        dispenser.dispense();
        display.unsetAll();
    }
    
    public static void main(String[] args) {
        SimpleMachine machine = new SimpleMachine();
        machine.run();
    }
}