package model;


import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;

abstract class Machine {
    protected List<MenuItem> menu;
    protected Dispenser dispenser;
    private String name;

    Machine(String name) {
        this.name = name;
        dispenser = new Dispenser();
        menu = new LinkedList<>();

        initialiseIngredients();
        populateMenu();
    }

    abstract void initialiseIngredients();

    abstract void populateMenu();

    void run() {
        Scanner input = new Scanner(System.in);

        while (true) {
            System.out.println("");
            System.out.println("----------------------------");
            System.out.println(name);
            System.out.println("");
            for(MenuItem b : menu) {
                b.render();
            }
            System.out.println("");
            System.out.println("999. Exit");
            System.out.println("");
            System.out.println("Enter your choice");

            int selection = input.nextInt();
            input.nextLine();

            boolean selectionMade = false;

            for(MenuItem b : menu) {
                if (b.match(selection)) {
                    ((Button)b).press();
                    selectionMade = true;
                    break;
                }
            }

            if (!selectionMade) {
                if (selection == 999) {
                    break;
                } else {
                    System.out.println("Invalid selection.");
                }
            }
        }
    }
}
