package model;

import java.util.function.Consumer;

class Ingredient {
   
	int max;
	String name;
    int quantity;
    Consumer<Ingredient> onEmptyAction;
    Dispenser dispenser;
    
    Ingredient(String name, int max, Dispenser dispenser) {
        this.dispenser = dispenser;
		this.name = name;
		this.max = max;
        this.quantity = max;
    }
    
    void onEmpty(Consumer<Ingredient> f) {
        this.onEmptyAction = f;
    }
    
    boolean empty() { return quantity == 0; }
    
    void use() {
        if (empty() && onEmptyAction != null) {
            onEmptyAction.accept(this);
        } else {
            quantity--;
            dispenser.addIngredient(name);
        }
    }
    
    void refill() {
        System.out.print(name + "refilled");
        quantity = max;
    }
}

