package model;

import java.util.Scanner;

class FancyMachine extends Machine {
    
    final static int SUGAR_MAX = 20;
    final static int COFFEE_MAX = 20;
    final static int MILK_MAX = 20;
    final static int CHOCOLATE_MAX = 20;
    final static int WATER_MAX = Integer.MAX_VALUE;
    final static int CUP_MAX = 10;
    
    private Ingredient hotwater, coffee, milk, sugar, chocolate, cups;
    private CashPayment payment;
    private CardPayment cardreader;
    private FancyDisplay display;
    boolean useCard = false;

    FancyMachine() {
        super("Dave's Famous Coffee Machine");
    }

    void initialiseIngredients() {
        hotwater  = new Ingredient("Water", WATER_MAX, dispenser);
        coffee    = new Ingredient("Coffee", COFFEE_MAX, dispenser);
        milk      = new Ingredient("Milk", MILK_MAX, dispenser);
        sugar     = new Ingredient("Sugar", SUGAR_MAX, dispenser);
        chocolate = new Ingredient("Chocolate", CHOCOLATE_MAX, dispenser);
        cups      = new Ingredient("Cup", CUP_MAX, dispenser);
        payment   = new CashPayment();
        cardreader = new CardPayment();
        display   = new FancyDisplay();

        coffee.onEmpty( s -> { display.setText("Coffee Empty."); } );
        milk.onEmpty( s -> { display.setText("Milk Empty."); } );
        sugar.onEmpty( s -> { display.setText("Sugar Empty."); } );
        chocolate.onEmpty( s -> { display.setText("Chocolate Empty."); } );
        cups.onEmpty( s -> { display.setText("No cups available. Please use own cup"); } );
    }

    void populateMenu() {
        menu.add(new Button(1, "Tea", b -> this.tea()));
        menu.add(new Button(2, "Coffee", b -> this.coffee()));
        menu.add(new Button(3, "Milk", b -> this.milk()));
        menu.add(new Button(4, "Sugar", b -> this.sugar()));
        menu.add(new Button(5, "Cup", b -> this.cup()));
        menu.add(new Button(6, "Insert Coin", b -> this.coin()));
        menu.add(new Button(7, "Insert Card", b -> { this.useCard = true;} ));
        menu.add(new TextItem(""));
        menu.add(new TextItem("The fancy stuff"));
        menu.add(new Button(11, "Espresso", b -> this.espresso()));
        menu.add(new Button(12, "Latte", b -> this.latte()));
        menu.add(new Button(13, "Cappuccino", b -> this.cappuccino()));
        menu.add(new Button(14, "Hot Chocolate", b -> this.hotchocolate()));
        menu.add(new TextItem(""));
        menu.add(new Button(50, "Cancel", b -> this.cancel()));
        menu.add(new TextItem(""));
        menu.add(new Button(100, "Dispense", b -> this.dispense()));
        menu.add(new TextItem(""));
        menu.add(new TextItem("----------------------------"));
        menu.add(new TextItem("Maintenance Menu"));
        menu.add(new TextItem(""));
        menu.add(new Button(401, "Refill Coffee", b -> this.refillCoffee()));
        menu.add(new Button(402, "Refill Milk", b -> this.refillMilk()));
        menu.add(new Button(403, "Refill Sugar", b -> this.refillSugar()));
        menu.add(new Button(404, "Refill Cups", b -> this.refillCups()));
    }

    void tea() {
        hotwater.use();
    }

    void coffee() {
        coffee.use();
    }

    void milk() {
        milk.use();
    }

    void sugar() {
        sugar.use();
    }

    void espresso() {
        coffee.use();
    }
    
    void latte() {
        coffee.use();
        milk.use();
        milk.use();
        milk.use();
    }
    
    void cappuccino() {
        coffee.use();
        milk.use();
        milk.use();
    }
    
    void hotchocolate() {
        sugar.use();
        hotwater.use();
        milk.use();
        chocolate.use();
    }


    void coin() {
        payment.insert();
    }
    
    void cup() {
        cups.use();
    }
    
    void dispense() {
        if (useCard) {
          cardreader.pay();
        } else if (payment.enough(1)) {
            dispenser.dispense();
            int change = payment.deduct(1);
            System.out.println("Change given: " + change + " coin(s)");
        } else {
            System.out.println("Insufficient funds");
        }
        useCard = false;
    }

    void cancel() {
        useCard = false;
        int change = payment.cancel();
        dispenser.cancel();
        display.setText("Order cancelled.");
        System.out.println("Returned " + change + " coin(s);");
    }

    void refillCoffee () {
        coffee.refill();
    }

    void refillSugar () {
        sugar.refill();
    }

    void refillMilk () {
        milk.refill();
    }

    void refillCups () {
        cups.refill();
    }

    public static void main(String[] args) {
        FancyMachine machine = new FancyMachine();
        machine.run();
    }
}