package model;

import java.util.function.Consumer;

class Button extends MenuItem {

    Consumer<Button> action;
    String menuText;
    int id;
    boolean enabled = true;


    Button(int id, String text, Consumer<Button> action) {
        this.id = id;
        this.menuText = text;
        this.action = action;
    }

    void render() {
        System.out.println(id + ". " + menuText);
    }

    void setAction(Consumer<Button> action) {
        this.action = action;
    }

    void press() {
        if (enabled && action != null) {
            action.accept(this);
        }
    }

    boolean match(int id) {
        return this.id == id;
    }

    boolean isEnabled() {
        return enabled;
    }

    void enable() {
        enabled = true;
    }
    void disable() {
        enabled = false;
    }
}
